/******************************************************************************
* (C) Copyright 2007 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

#ifndef AGTPCIEERROR_H
#define AGTPCIEERROR_H

#include <exception>
#include <ostream>
#include "AgtPCIPort.h" // For UInt32

// Shortcut providing file and line information
#define AGT_THROW(msg) (throw(CAgtException(msg,__FILE__,__LINE__)))

/// Exception class thrown by classes CAgtPortSelector and CAgtPCIEExerciser.
/** Exception class thrown by classes CAgtPortSelector and CAgtPCIEExerciser.
*/
class AGTPCIPORT_API CAgtException
{
public:
  CAgtException( const char*msg, const char *file, UInt32 line );
  ~CAgtException( void );

  /// Provides an error description of the exception.
  /** Provides an error description of the exception.
  Call from your catch block.
  Overwrites exception::what().
  */
  virtual const char *what() const;
  friend AGTPCIPORT_API std::ostream&  operator << (std::ostream&,const CAgtException&);

protected:
  char *myerrmsg;
};

AGTPCIPORT_API std::ostream&  operator << (std::ostream&,const CAgtException&);

#endif